DROP PROCEDURE [hips].[HospitalCodeGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon
-- Create date: 18 July 2012
-- Description:   Gets specified records from the HospitalCode Table
-- =============================================
CREATE PROCEDURE [hips].[HospitalCodeGet] 
(
	 @HospitalId INT = NULL
	,@CodeSystemId INT = NULL
) AS

BEGIN

SELECT hc.[HospitalId]
      ,hc.[CodeSystemId]
      ,hc.[Code]
      ,cs.Code As CodeSystemCode
      ,hc.[DateCreated]
      ,hc.[UserCreated]
      ,hc.[DateModified]
      ,hc.[UserModified]
FROM   [HospitalCode] hc 
inner join CodeSystem cs on hc.CodeSystemId = cs.CodeSystemId

WHERE (hc.[HospitalId] = @HospitalId OR @HospitalId IS NULL)
AND   (hc.[CodeSystemId] = @CodeSystemId         OR @CodeSystemId IS NULL)

END
GO

